## Overview
- Spam email is the most common type of unsolicited email, sent in bulk to users' corporate or personal addresses.
- Graymail is a type of spam initially wanted by recipients but loses value over time.

## Actions on Spam and Graymail

##### Organizational Obligations
- Protect against unwanted email messages.
- Safe unsubscribing helps prevent phishing attacks.

## SenderBase and Reputation Scores

Senderbase combines multiple sources to info to determine a "reputation score" for any IP address: 

- Email volume information provided by thousands of organizations that regularly receive internet email.
- Spam complaints received by the SpamCop service.
- Information on other DNS-based blocked lists.

##### SenderBase Overview
- Part of Cisco Talos, helps manage incoming email streams.
- Provides data to differentiate legitimate senders from spam sources.
- SenderBase Reputation Score (SBRS) assesses IP address likelihood of sending spam. The SBRS returns a score based on the probability that a message from a given source is spam, ranging from –10 (certain to be spam) through 0 to +10 (certain not to be spam).
##### Use SenderBase in Various Ways:
- Research email senders and IP addresses at the Cisco Talos Intelligence Group website.
- Use DNS-based queries in Cisco Secure Email to throttle, block, or trust senders.
- Integrate SenderBase scores into message filters and mail flow policies.

##### SBRS Implementation Strategies
![[Pasted image 20250421153029.png]]

##### Sender Groups and SBRS Ranges
- Configure sender groups based on SBRS ranges in the Host Access Table (HAT).
- Modify default predefined sender groups or create custom groups with SBRS ranges.
- Order matters in sender group evaluation and policy application.

![[Pasted image 20250421153529.png]]


## Antispam Filtering Solutions
![[Pasted image 20250421155503.png]]

Cisco Secure Email offers two antispam solution and you can license and enable both these solutions on your Cisco Secure Email, but you can only use one in a particular mail policy:
##### Cisco IronPort Anti-Spam
- Addresses threats such as spam, phishing, zombie attacks, etc.
- Analyzes multidimensional relationships to maintain accuracy.

IronPort Anti-Spam analyzes over 100,000 message attributes across the following dimensions:
- **Email reputation:** _Who_ is sending you this message?
- **Message content:** _What_ content is included in this message?
- **Message structure:** _How_ was this message constructed?
- **Web reputation:** _Where_ does the call to action take you?

##### Cisco Intelligent Multi-Scan
- Incorporates multiple antispam engines for a multilayer solution. Will send to third-party antispam scanning engines and then: (below point)
- Applies a combined multi-scan score for final verdicts.

## Spam Detection and Actions
##### Configuring Spam Detection
- Enable spam detection in mail flow policies for controlling antispam filtering.
- Specify antispam solution per policy: Cisco IronPort or Intelligent Multi-Scan.
- Configure thresholds and actions for positively identified and suspected spam.
##### Sample Actions
- **Aggressive Approach**: Drop positively identified spam, deliver suspected spam.
- **Conservative Approach**: Deliver with altered subject for both positively identified and suspected spam.

## Graymail Management

![[Pasted image 20250421160853.png]]

##### Graymail Detection and Safe Unsubscribe
- Enable graymail detection and safe unsubscribing features.
- Graymail includes **marketing**, **social network**, and **bulk email** categories.
- Secure unsubscribe protects users from phishing threats.

![[Pasted image 20250421160558.png]]

The graymail solution of Cisco Secure Email helps to provide protection in the following ways:

- **Provide a secure unsubscribe option:** Mimicking an unsubscribe option is a popular phishing technique. For this reason, end users are generally wary of clicking unknown unsubscribe links. For such scenarios, the cloud-based Unsubscribe Service extracts the original unsubscribe URI, checks the reputation of the URI, and then performs the unsubscribe process on behalf of the end user. The behavior protects end users from malicious threats masquerading as unsubscribe links.
    
- **Uniform subscription management interface for end users:** Different graymail senders use different layouts for displaying unsubscribe links to the users. The users must search for the unsubscribe link in the message body and perform the unsubscribing. Irrespective of the graymail senders, the graymail management solution provides a common layout for displaying unsubscribe links to the users.
    
- **Better visibility for administrators into various graymail categories:** The graymail engine classifies each graymail into three categories and the administrators can set policy controls based on these categories.

 ![[Pasted image 20250421160708.png]]
The graymail engine classifies each graymail into one of the following categories:

- **Marketing email:** Advertising email messages sent by professional marketing groups—for example, bulletins from a third-party vendor with details about their newly launched products.
    
- **Social network email:** Notification email messages from social networks, dating websites, forums, and so on. Examples include alerts from LinkedIn for jobs that you may be interested in or CNET forums, when a user responds to your post.
    
- **Bulk email:** Advertising email messages sent by unrecognized marketing groups—for example, newsletters from TechTarget, a technology media company.

